using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;
using System.Text;
using System.IO;


namespace DemoHtmlApp
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnLoad;
		private System.Windows.Forms.Button btnSource;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.CheckBox chkEditMode;
		private System.Windows.Forms.Button btnCount;
		private System.Windows.Forms.ToolBar toolBar1;
		private System.Windows.Forms.ToolBarButton toolBarButton1;
		private System.Windows.Forms.ToolBarButton toolBarButton2;
		private System.Windows.Forms.ToolBarButton toolBarButton3;
		private System.Windows.Forms.ToolBarButton toolBarButton4;
		private System.Windows.Forms.ToolBarButton toolBarButton5;
		private System.Windows.Forms.ToolBarButton toolBarButton6;
		private System.Windows.Forms.ToolBarButton toolBarButton7;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem mnuItemCopy;
		private System.Windows.Forms.Button btnParseNodes;
		private onlyconnect.HtmlEditor htmlEditor1;
		
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.ToolBarButton toolBarButton8;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.mnuItemCopy = new System.Windows.Forms.MenuItem();
			this.btnLoad = new System.Windows.Forms.Button();
			this.btnSource = new System.Windows.Forms.Button();
			this.btnPrint = new System.Windows.Forms.Button();
			this.chkEditMode = new System.Windows.Forms.CheckBox();
			this.btnCount = new System.Windows.Forms.Button();
			this.toolBar1 = new System.Windows.Forms.ToolBar();
			this.toolBarButton1 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton2 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton3 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton4 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton5 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton6 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton7 = new System.Windows.Forms.ToolBarButton();
			this.btnParseNodes = new System.Windows.Forms.Button();
			this.htmlEditor1 = new onlyconnect.HtmlEditor();
			this.toolBarButton8 = new System.Windows.Forms.ToolBarButton();
			this.SuspendLayout();
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.mnuItemCopy});
			// 
			// mnuItemCopy
			// 
			this.mnuItemCopy.Index = 0;
			this.mnuItemCopy.Text = "Copy";
			this.mnuItemCopy.Click += new System.EventHandler(this.mnuItemCopy_Click);
			// 
			// btnLoad
			// 
			this.btnLoad.Location = new System.Drawing.Point(8, 248);
			this.btnLoad.Name = "btnLoad";
			this.btnLoad.Size = new System.Drawing.Size(64, 32);
			this.btnLoad.TabIndex = 1;
			this.btnLoad.Text = "Load HTML";
			this.btnLoad.Click += new System.EventHandler(this.btnLoad_Click);
			// 
			// btnSource
			// 
			this.btnSource.Location = new System.Drawing.Point(80, 248);
			this.btnSource.Name = "btnSource";
			this.btnSource.Size = new System.Drawing.Size(48, 32);
			this.btnSource.TabIndex = 2;
			this.btnSource.Text = "View source";
			this.btnSource.Click += new System.EventHandler(this.btnSource_Click);
			// 
			// btnPrint
			// 
			this.btnPrint.Location = new System.Drawing.Point(136, 248);
			this.btnPrint.Name = "btnPrint";
			this.btnPrint.Size = new System.Drawing.Size(64, 32);
			this.btnPrint.TabIndex = 3;
			this.btnPrint.Text = "Print with preview";
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			// 
			// chkEditMode
			// 
			this.chkEditMode.Location = new System.Drawing.Point(8, 288);
			this.chkEditMode.Name = "chkEditMode";
			this.chkEditMode.Size = new System.Drawing.Size(344, 16);
			this.chkEditMode.TabIndex = 4;
			this.chkEditMode.Text = "Edit mode (requires document reload)";
			this.chkEditMode.CheckedChanged += new System.EventHandler(this.chkEditMode_CheckedChanged);
			// 
			// btnCount
			// 
			this.btnCount.Location = new System.Drawing.Point(208, 248);
			this.btnCount.Name = "btnCount";
			this.btnCount.Size = new System.Drawing.Size(64, 32);
			this.btnCount.TabIndex = 5;
			this.btnCount.Text = "Edit using the DOM";
			this.btnCount.Click += new System.EventHandler(this.btnCount_Click);
			// 
			// toolBar1
			// 
			this.toolBar1.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
						this.toolBarButton1,
						this.toolBarButton2,
						this.toolBarButton3,
						this.toolBarButton4,
						this.toolBarButton5,
						this.toolBarButton6,
						this.toolBarButton7,
						this.toolBarButton8});
			this.toolBar1.ButtonSize = new System.Drawing.Size(50, 36);
			this.toolBar1.DropDownArrows = true;
			this.toolBar1.Location = new System.Drawing.Point(0, 0);
			this.toolBar1.Name = "toolBar1";
			this.toolBar1.ShowToolTips = true;
			this.toolBar1.Size = new System.Drawing.Size(424, 42);
			this.toolBar1.TabIndex = 6;
			this.toolBar1.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolBar1_ButtonClick);
			// 
			// toolBarButton1
			// 
			this.toolBarButton1.Text = "Cut";
			// 
			// toolBarButton2
			// 
			this.toolBarButton2.Text = "Copy";
			// 
			// toolBarButton3
			// 
			this.toolBarButton3.Text = "Paste";
			// 
			// toolBarButton4
			// 
			this.toolBarButton4.Text = "Bold";
			// 
			// toolBarButton5
			// 
			this.toolBarButton5.Text = "Italic";
			// 
			// toolBarButton6
			// 
			this.toolBarButton6.Text = "Heading";
			// 
			// toolBarButton7
			// 
			this.toolBarButton7.Text = "Table";
			// 
			// btnParseNodes
			// 
			this.btnParseNodes.Location = new System.Drawing.Point(280, 248);
			this.btnParseNodes.Name = "btnParseNodes";
			this.btnParseNodes.Size = new System.Drawing.Size(56, 32);
			this.btnParseNodes.TabIndex = 8;
			this.btnParseNodes.Text = "Parse nodes";
			this.btnParseNodes.Click += new System.EventHandler(this.btnParseNodes_Click);
			// 
			// htmlEditor1
			// 
			this.htmlEditor1.DocumentEncoding = onlyconnect.EncodingType.WindowsCurrent;
			this.htmlEditor1.IsActivationEnabled = true;
			this.htmlEditor1.isActiveContentEnabled = true;
			this.htmlEditor1.IsAnsiStreamAlwaysUsed = false;
			this.htmlEditor1.IsContextMenuEnabled = true;
			this.htmlEditor1.IsDesignMode = false;
			this.htmlEditor1.Location = new System.Drawing.Point(8, 48);
			this.htmlEditor1.Name = "htmlEditor1";
			this.htmlEditor1.Size = new System.Drawing.Size(412, 188);
			this.htmlEditor1.TabIndex = 9;
			this.htmlEditor1.Text = "htmlEditor1";
			this.htmlEditor1.HtmlEvent += new onlyconnect.HtmlEventHandler(this.htmlEditor1_HtmlEvent);
			// 
			// toolBarButton8
			// 
			this.toolBarButton8.Text = "About";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 310);
			this.ContextMenu = this.contextMenu1;
			this.Controls.Add(this.toolBar1);
			this.Controls.Add(this.htmlEditor1);
			this.Controls.Add(this.btnParseNodes);
			this.Controls.Add(this.btnCount);
			this.Controls.Add(this.chkEditMode);
			this.Controls.Add(this.btnPrint);
			this.Controls.Add(this.btnSource);
			this.Controls.Add(this.btnLoad);
			this.Name = "Form1";
			this.Text = "HTML Editor demo";
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void btnLoad_Click(object sender, System.EventArgs e)
		{

			StringBuilder sb = new StringBuilder();
				sb.Append("<html><body ><h1>HTML Example</h1><p onClick=\"alert('Simple script demo');\">Some body text - click to see if scripts are enabled.</p>");
				sb.Append("<p><i>You can disable scripts, Java etc with the isActiveContentEnabled property</i></p>");
			sb.Append("<p><form><input type=\"text\"/><br/></form></p>");
			sb.Append("<p><font color=\"red\">Coloured text</font></p></body></html>");

			this.htmlEditor1.LoadDocument(sb.ToString());
	
		}

		private void btnSource_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show(this,htmlEditor1.GetDocumentSource());
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			
			htmlEditor1.print(true,string.Empty);
		}

		private void chkEditMode_CheckedChanged(object sender, System.EventArgs e)
		{
			if (chkEditMode.Checked)
			{
				this.htmlEditor1.IsDesignMode = true;
							}
			else
			{
				this.htmlEditor1.IsDesignMode = false;
			}
		}

		private void btnCount_Click(object sender, System.EventArgs e)
		{
			//demo DOM
			mshtml.HTMLDocument doc = this.htmlEditor1.Document;
			mshtml.IHTMLElement el = doc.body;
			MessageBox.Show("This example shows the innerHTML of the body element");
			MessageBox.Show(el.innerHTML);
			MessageBox.Show("Now we change this using the DOM");
			el.innerHTML = "<h1>Edited through the DOM</h1>";
	
		}

		private void toolBar1_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			switch (e.Button.Text)
			{

				case ("Cut"): 
			
				if (this.htmlEditor1.IsDesignMode) 
				{
					this.htmlEditor1.Document.execCommand("cut",false,null);
				}
				break;

				case("Copy"):
					this.htmlEditor1.Document.execCommand("copy",false,null);
					break;

				case("Paste"):

					if (this.htmlEditor1.IsDesignMode) 
					{
						this.htmlEditor1.Document.execCommand("paste",false,null);
					}
					break;

				case("Bold"):
					if (this.htmlEditor1.IsDesignMode) 
					{
						this.htmlEditor1.Document.execCommand("bold",false,null);
					}
					break;

				case("Italic"):
					if (this.htmlEditor1.IsDesignMode) 
					{
						this.htmlEditor1.Document.execCommand("italic",false,null);
					}
					break;

				case("Heading"):
					{
					//This is not intended as solid code, but gives an
					//idea about how you might edit the DOM 
					//to provide editor features

					//it's actually easier to edit styles using CSS as you can change
					//an attribute more easily than the tagname
					mshtml.IHTMLElement el = null;
					try
					{
						if (this.htmlEditor1.IsDesignMode) 
						{
							el = htmlEditor1.CurrentElement;
							if (el != null && el.tagName != "BODY")
							{
								el.outerHTML = "<h1>" + el.innerHTML + "</h1>";
							}
						}
					}
					catch (Exception exc)
					{
						string sMessage = "Could not apply heading: " + exc.Message;
						if (el != null)
						{
							sMessage += " The possible reason is the the tag is " + el.tagName + ".";
						}
						MessageBox.Show(sMessage);
					}

					}
					break;
				case("Table"):
				{
					//here's some code to insert a table
					//would be a lot quicker just to insert the html

					try
					{
						mshtml.IHTMLTable t = (mshtml.IHTMLTable)htmlEditor1.Document.createElement("table");

						//set the cols
						t.cols = 3;
						//insert two rows at the end

						t.border = 2;

						for (int i = 0; i <= 4; i++)
						{
							mshtml.IHTMLTableRow tr = (mshtml.IHTMLTableRow) t.insertRow(-1);
							for (int j = 0; j <= 3; j++)
							{
								mshtml.IHTMLElement c = (mshtml.IHTMLElement) tr.insertCell(-1);
								c.innerHTML = j.ToString();
							}
						}

						mshtml.IHTMLDOMNode nd = (mshtml.IHTMLDOMNode) t;
						mshtml.IHTMLDOMNode body = (mshtml.IHTMLDOMNode)htmlEditor1.Document.body;
						body.appendChild(nd);


					}
					catch (Exception exc)
					{
						MessageBox.Show(exc.Message);
					}
				}

					break;

					case("About"):
					{
						frmAbout f = new frmAbout();
						f.ShowDialog();
						f.Dispose();
					}

					break;
			}



		}

		private void htmlEditor1_HtmlEvent(object s, onlyconnect.HtmlEventArgs e)
		{
			mshtml.IHTMLEventObj Event = e.Event;

			//Write out the event for debug
			Debug.WriteLine("Event Info\nType: " + Event.type + "\nElement: " +
				Event.srcElement );
		
		}

		private void mnuItemCopy_Click(object sender, System.EventArgs e)
		{
				this.htmlEditor1.Document.execCommand("copy",false,null);
		}

		private void btnParseNodes_Click(object sender, System.EventArgs e)
		{
			//parse all the nodes in the document using recursion

			if (htmlEditor1.Document != null)
			{
			mshtml.IHTMLDOMNode nd = (mshtml.IHTMLDOMNode) htmlEditor1.Document.body;
				parseNodes(nd);
			}

		}

		private void parseNodes(mshtml.IHTMLDOMNode nd)
		{
			Debug.WriteLine (nd.nodeName);
			if (nd.hasChildNodes())
			{
              mshtml.IHTMLDOMChildrenCollection nds = (mshtml.IHTMLDOMChildrenCollection) nd.childNodes;
                
                foreach (mshtml.IHTMLDOMNode childnd in nds)
				{
					parseNodes(childnd);
				}

			}
		}

	}
}
